       #include "MCU.h"


void MCU_Init(void)
{
    SOPT1 = 0x13;                   // disable COP                 
  
  	MCGTRM = NV1MCGTRM;
  	MCGSC_FTRIM = NV1FTRIM_FTRIM;

/* JM60 code  	
    MCGC2 = 0x36;	//0b0110110
    
    while(!(MCGSC & 0x02));		      //wait for the OSC stable
    MCGC1 = 0x98;
    
    
    
    while((MCGSC & 0x1C ) != 0x08); // external clock is selected
	MCGC3 = 0x48;
	while ((MCGSC & 0x48) != 0x48);	//wait for the PLL is locked
	MCGC1 = 0x18;
    while((MCGSC & 0x6C) != 0x6C);
*/

/* device initialization code */
#ifdef DEVICE_INIT_CODE
	MCGC2 = 0x36;                        /* Set MCGC2 register */
	/* MCGC1: CLKS=2,RDIV=7,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
	MCGC1 = 0xB8;                        /* Set MCGC1 register */
	while(!MCGSC_OSCINIT) {              /* Wait until external reference is stable */
	}
	while(MCGSC_IREFST) {                /* Wait until external reference is selected */
	}
	while((MCGSC & 0x0C) != 0x08) {      /* Wait until external clock is selected as a bus clock reference */
	}
	/* MCGC2: BDIV=0,RANGE=1,HGO=1,LP=1,EREFS=1,ERCLKEN=1,EREFSTEN=0 */
	MCGC2 = 0x3E;                        /* Set MCGC2 register */
	/* MCGC1: CLKS=2,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
	MCGC1 = 0x98;                        /* Set MCGC1 register */
	/* MCGC3: LOLIE=0,PLLS=1,CME=0,VDIV=6 */
	MCGC3 = 0x46;                        /* Set MCGC3 register */
	/* MCGC2: LP=0 */
	MCGC2 &= (unsigned char)~0x08;                     
	while(!MCGSC_PLLST) {                /* Wait until PLL is selected */
	}
	while(!MCGSC_LOCK) {                 /* Wait until PLL is locked */
	}
	/* MCGC1: CLKS=0,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
	MCGC1 = 0x18;                        /* Set MCGC1 register */
	while((MCGSC & 0x0C) != 0x0C) {      /* Wait until PLL clock is selected as a bus clock reference */
	}

#else
/* cdc cmx code */
 /* Assume 16MHz external clock source connected. */
  
  /* In order to use the USB we need to enter PEE mode and MCGOUT set to 48 MHz. 
     Out of reset MCG is in FEI mode. */
     
  /**** Moving from FEI (FLL engaged internal) to PEE (PLL engaged external) mode. */ 
  /* switch from FEI to FBE (FLL bypassed external) */ 
    /* enable external clock source */
  MCGC2 = MCGC2_HGO_MASK       /* oscillator in high gain mode */
          | MCGC2_EREFS_MASK   /* because crystal is being used */
          | MCGC2_RANGE_MASK   /* 16 MHz is in high freq range */
          | MCGC2_ERCLKEN_MASK;     /* activate external reference clock */
  while (MCGSC_OSCINIT == 0)
    ;
    /* select clock mode */
  MCGC1 = (2<<6)         /* CLKS = 10 -> external reference clock. */
          | (3<<3);      /* RDIV = 3 -> 16MHz/8=2 MHz */
  
    /* wait for mode change to be done */
  while (MCGSC_IREFST != 0){}
  while (MCGSC_CLKST != 2){}
    
  /* switch from FBE to PBE (PLL bypassed internal) mode */
  MCGC3=MCGC3_PLLS_MASK
        | (6<<0);     /* VDIV=6 -> multiply by 24 -> 2MHz * 24 = 48MHz */
  while(MCGSC_PLLST != 1){}
  while(MCGSC_LOCK != 1){}
  /* finally switch from PBE to PEE (PLL enabled external mode) */
  MCGC1 = (0<<6)         /* CLKS = 0 -> PLL or FLL output clock. */
          | (3<<3);      /* RDIV = 3 -> 16MHz/8=2 MHz */
  while(MCGSC_CLKST!=3){}

#endif
}
